<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################
?>
	<h1 id="settings">Settings and Preferences</h1>

	<br />
	<?php
		if (check_permissions("../config_settings.php")) {
			echo "<div align=\"center\"><span class=\"loginMessage\">Before changes can be saved, you must CHMOD config_settings.php to writable status (666).</span></div><br />";
		}
		?>
	<form name="change_settings" action="./manage_action.php?go=changesettings&amp;ref=<?php echo $_SERVER['REQUEST_URI']; ?>" method="post" id="change_settings" onsubmit="return validate_change_settings(this);">

		<fieldset>
			<legend>Notification Settings</legend>
			<label for="email"><strong>Email Address: </strong></label>
			<input name="email" type="text" id="email" size="30" value="<?php echo $email; ?>" <?php disable_if_not_writable(); ?> />
			<br />
			<br />
			<label for="email"><strong>Confirm Email: </strong></label>
			<input name="email_confirm" type="text" id="email_confirm" size="30" value="<?php echo $email; ?>" <?php disable_if_not_writable(); ?> />
			<br />
			<br />

			<label for="emailnotice"><strong>Email Notice: </strong></label>
			<input name="emailnotice" type="radio" value="true" checked="checked" <?php disable_if_not_writable(); ?>/> Yes
			<input name="emailnotice" type="radio" value="false" <?php if (!$email_notice) { echo "checked=\"checked\""; } disable_if_not_writable(); ?>/> No
			<br />
			<label>Would you like to receive an email after every reported click?</label>
			<br />
			<br />

			<label for="emailalert"><strong>Email Alert: </strong></label>
			<input name="emailalert" type="radio" value="true" checked="checked" <?php disable_if_not_writable(); ?>/> Yes
			<input name="emailalert" type="radio" value="false" <?php if (!$email_alert) { echo "checked=\"checked\""; } disable_if_not_writable(); ?>/> No
			<br />
			<label>Would you like to receive an email after multiple clicks from the same IP address?</label>
			<br />
			<br />

			<label for="emailalert_num">If yes, after how many reported clicks would you like an email alert?</label>
			<input name="emailalert_num" type="text" value="<?php echo $emailalert_num; ?>" size="4" <?php disable_if_not_writable(); ?>/>

			<br />
		</fieldset>

		<br />

		<fieldset>
			<legend>Timezone Setting</legend>
				<div align="center">
				<br />
				Your server's time is set at <?php echo date('g:i A', time()) . " on " . date('l, F jS, Y', time()); ?>.
				<br /><br />
				If that is not correct, choose the correct time from this list of choices.
				<br /><br />
					<select name="timezone">
						<option value="-12" <?php select_item_if_chosen('-12', $gmt_dif); ?>> - 12:00 ---- <?php time_change(-12); ?></option>
						<option value="-11" <?php select_item_if_chosen('-11', $gmt_dif); ?>> - 11:00 ---- <?php time_change(-11); ?></option>
						<option value="-10" <?php select_item_if_chosen('-10', $gmt_dif); ?>> - 10:00 ---- <?php time_change(-10); ?></option>
						<option value="-9" <?php select_item_if_chosen('-9', $gmt_dif); ?>> - 9:00 ---- <?php time_change(-9); ?></option>
						<option value="-8" <?php select_item_if_chosen('-8', $gmt_dif); ?>> - 8:00 ---- <?php time_change(-8); ?></option>
						<option value="-7" <?php select_item_if_chosen('-7', $gmt_dif); ?>> - 7:00 ---- <?php time_change(-7); ?></option>
						<option value="-6" <?php select_item_if_chosen('-6', $gmt_dif); ?>> - 6:00 ---- <?php time_change(-6); ?></option>
						<option value="-5" <?php select_item_if_chosen('-5', $gmt_dif); ?>> - 5:00 ---- <?php time_change(-5); ?></option>
						<option value="-4" <?php select_item_if_chosen('-4', $gmt_dif); ?>> - 4:00 ---- <?php time_change(-4); ?></option>
						<option value="-3.5" <?php select_item_if_chosen('-3.5', $gmt_dif); ?>> - 3:30 ---- <?php time_change(-3.5); ?></option>
						<option value="-3" <?php select_item_if_chosen('-3', $gmt_dif); ?>> - 3:00 ---- <?php time_change(-3); ?></option>
						<option value="-2" <?php select_item_if_chosen('-2', $gmt_dif); ?>> - 2:00 ---- <?php time_change(-2); ?></option>
						<option value="-1" <?php select_item_if_chosen('-1', $gmt_dif); ?>> - 1:00 ---- <?php time_change(-1); ?></option>
						<option value="0" <?php select_item_if_chosen('0', $gmt_dif); ?>> + 0:00 ---- <?php time_change(0); ?></option>
						<option value="1" <?php select_item_if_chosen('1', $gmt_dif); ?>> + 1:00 ---- <?php time_change(1); ?></option>
						<option value="2" <?php select_item_if_chosen('2', $gmt_dif); ?>> + 2:00 ---- <?php time_change(2); ?></option>
						<option value="3" <?php select_item_if_chosen('3', $gmt_dif); ?>> + 3:00 ---- <?php time_change(3); ?></option>
						<option value="3.5" <?php select_item_if_chosen('3.5', $gmt_dif); ?>> + 3:30 ---- <?php time_change(3.5); ?></option>
						<option value="4" <?php select_item_if_chosen('4', $gmt_dif); ?>> + 4:00 ---- <?php time_change(4); ?></option>
						<option value="4.5" <?php select_item_if_chosen('4.5', $gmt_dif); ?>> + 4:30 ---- <?php time_change(4.5); ?></option>
						<option value="5" <?php select_item_if_chosen('5', $gmt_dif); ?>> + 5:00 ---- <?php time_change(5); ?></option>
						<option value="5.5" <?php select_item_if_chosen('5.5', $gmt_dif); ?>> + 5:30 ---- <?php time_change(5.5); ?></option>
						<option value="6" <?php select_item_if_chosen('6', $gmt_dif); ?>> + 6:00 ---- <?php time_change(6); ?></option>
						<option value="7" <?php select_item_if_chosen('7', $gmt_dif); ?>> + 7:00 ---- <?php time_change(7); ?></option>
						<option value="8" <?php select_item_if_chosen('8', $gmt_dif); ?>> + 8:00 ---- <?php time_change(8); ?></option>
						<option value="9" <?php select_item_if_chosen('9', $gmt_dif); ?>> + 9:00 ---- <?php time_change(9); ?></option>
						<option value="9.5" <?php select_item_if_chosen('9.5', $gmt_dif); ?>> + 9:30 ---- <?php time_change(9.5); ?></option>
						<option value="10" <?php select_item_if_chosen('10', $gmt_dif); ?>> + 10:00 ---- <?php time_change(10); ?></option>
						<option value="11" <?php select_item_if_chosen('11', $gmt_dif); ?>> + 11:00 ---- <?php time_change(11); ?></option>
						<option value="12" <?php select_item_if_chosen('12', $gmt_dif); ?>> + 12:00 ---- <?php time_change(12); ?></option>
					</select>
					<br /><br />
					The current setting is for <?php echo "<strong>" . date('g:i A', $timestamp) . "</strong> on <strong>" . date('l, F jS, Y', $timestamp) . "</strong>."; ?>
				</div>
			<br />
		</fieldset>

		<br />

		<fieldset>
			<legend>Click Fraud Settings</legend>

				<br />
				<div align="center">Should the script check against the database to determine if it should show ads?</div>

				<label>IP Database Check:</label>
				<input name="ip_db_check" type="radio" value="true" checked="checked" <?php disable_if_not_writable(); ?>/> Yes
				<input name="ip_db_check" type="radio" value="false" <?php if (!$ip_db_check) echo "checked=\"checked\""; disable_if_not_writable(); ?>/> No

				<br /><br />

			<div align="center">
				A visitor can click a maximum of
					<input name="clickmax" type="text" value="<?php echo $clickmax; ?>" size="3" <?php disable_if_not_writable(); ?>/>
				ad(s) every
					<input name="clickmaxtime" type="text" value="<?php echo ($clickmaxtime / 3600); ?>" size="3" <?php disable_if_not_writable(); ?>/>
				hour(s).
			</div>

		</fieldset>

		<br />

		<fieldset>
			<legend>Banned IPs</legend>

			<label>Banned IPs and IP ranges.</label>
			<textarea name="bannedips" rows="5" cols="30" <?php disable_if_not_writable(); ?>><?php
				/*
				 * Show the banned array as a list.
				 */
				$bannedstring = '';
				foreach($ip_range_ban_list as $i => $ip){
					if ($i != 0) {
						$bannedstring .= "\n";
					}
					$bannedstring .= "$ip";
				}
				echo $bannedstring;
			?></textarea>

			<br />
			<br />

			<div align="center">
				If using the PHP Wrapping Code, ads will not appear for the IP addresses/ranges that you enter. (eg: 192.168.0.1 and	213.94.). Separate by new line.
				
				<br /><br />
				
				If you have a static IP address, you can enter <?php echo "<strong>" . $_SERVER['REMOTE_ADDR'] . "</strong>"; ?> (your IP) to disable ads for yourself.
			</div>
		</fieldset>

		<br />

		<fieldset>
			<legend>Disable All Ads</legend>

			<label>Disable all ads for everyone?</label>
				<input name="disable_all_ads" type="radio" value="true" checked="checked" <?php disable_if_not_writable(); ?>/> Yes
				<input name="disable_all_ads" type="radio" value="false" <?php if (!$disable_all_ads) { echo "checked=\"checked\""; } disable_if_not_writable(); ?>/> No
			<br />
			<br />
			<div align="center">
				All ads surrounded by the PHP Wrapping Code will not appear and will show the alternate ad, if specified.
			</div>

		</fieldset>

		<br />

		<fieldset>
			<legend>Save Changes</legend>
			<div align="center">
				<?php if (!check_permissions('../config_settings.php')) { ?>
					<input type="hidden" name="version_num" value="<?php echo $version_num; ?>" />
					<input type="submit" name="Submit2" value="Update" />
				<?php } else { 
					echo "<span class=\"loginMessage\">Before changes can be saved, you must CHMOD config_settings.php to writable status (666).</span><br />"; ?>
					<input type="submit" name="Submit2" value="Update" disabled="disabled" />
				<?php } ?>
			</div>
		</fieldset>

	</form>